<?php

use Contao\ManagerBundle\ContaoManager\Plugin as ManagerBundlePlugin;
use Contao\CoreBundle\Response\InitializeControllerResponse;
use Contao\ManagerBundle\HttpKernel\ContaoKernel;
use Symfony\Component\HttpFoundation\Request;

if (!defined('TL_SCRIPT')) {
    die('Your script is not compatible with Contao 4.');
}

/** @var Composer\Autoload\ClassLoader */
$loader = require __DIR__.'/../vendor/autoload.php';

ManagerBundlePlugin::autoloadModules(__DIR__.'/modules');

$request = Request::create('/_contao/initialize', 'GET', [], $_COOKIE, [], $_SERVER);
$request->attributes->set('_scope', ('BE' === TL_MODE ? 'backend' : 'frontend'));

ContaoKernel::setProjectDir(dirname(__DIR__));
$kernel = new ContaoKernel('prod', false);
$response = $kernel->handle($request);

// Send the response if not generated by the InitializeController
if (!$response instanceof InitializeControllerResponse) {
    $response->send();
    $kernel->terminate($request, $response);
    exit;
}
