<?php

/*
 * This file is part of Contao.
 *
 * (c) Leo Feyer
 *
 * @license LGPL-3.0-or-later
 */

namespace Contao\ManagerPlugin\Config;

use Contao\ManagerPlugin\PluginLoader;
use Symfony\Component\DependencyInjection\ContainerBuilder as SymfonyContainerBuilder;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

class ContainerBuilder extends SymfonyContainerBuilder
{
    /**
     * @var PluginLoader
     */
    private $pluginLoader;

    /**
     * @var array
     */
    private $managerConfig;

    /**
     * @param PluginLoader               $pluginLoader
     * @param array                      $managerConfig
     * @param ParameterBagInterface|null $parameterBag
     */
    public function __construct(PluginLoader $pluginLoader, array $managerConfig, ParameterBagInterface $parameterBag = null)
    {
        parent::__construct($parameterBag);

        $this->pluginLoader = $pluginLoader;
        $this->managerConfig = $managerConfig;
    }

    /**
     * Gets the manager configuration.
     *
     * @return array
     */
    public function getManagerConfig()
    {
        return $this->managerConfig;
    }

    /**
     * {@inheritdoc}
     */
    public function getExtensionConfig($name)
    {
        $configs = parent::getExtensionConfig($name);
        $plugins = $this->pluginLoader->getInstancesOf(PluginLoader::EXTENSION_PLUGINS);

        /** @var ExtensionPluginInterface[] $plugins */
        foreach ($plugins as $plugin) {
            $configs = $plugin->getExtensionConfig($name, $configs, $this);
        }

        return $configs;
    }
}
